//---------------------------------------------------------------------------

#ifndef KolejkaH
#define KolejkaH
//---------------------------------------------------------------------------

#include <windows.h>

//typedef unsigned char byte;
typedef unsigned short TCyfra;

class Kolejka
{
    public:
        virtual void WstawNaKoniec(const TCyfra element) = 0;
        virtual TCyfra ZdejmijZPoczatku(void) = 0;
        virtual unsigned __int64 IleZostalo(void) const = 0;
};


class KolejkaPlik : public Kolejka
{
    public:
        KolejkaPlik(const char nazwaPliku[MAX_PATH])
            :Kolejka()
        {
            strncpy(this->nazwaPliku,nazwaPliku,MAX_PATH);
        };
        void WstawNaKoniec(const TCyfra);
        TCyfra ZdejmijZPoczatku(void);
        unsigned __int64 IleZostalo(void) const;
    private:
        char nazwaPliku[MAX_PATH];
};

class KolejkaPamiec : public Kolejka
{
//vector<char>
};

#endif
